<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Block_Checkout_Cart_Item_Renderer extends Mage_Checkout_Block_Cart_Item_Renderer{

	/**
	 * Return booking options array
	 * @return array
	 */
	protected function _getBookingOptions(){
		$product = $this->getProduct();
		$data = array(
			new Zend_Date($product->getCustomOption('aw_booking_from')->getValue()." ". $product->getCustomOption('aw_booking_time_from')->getValue(), AW_Core_Model_Abstract::DB_DATETIME_FORMAT),
			new Zend_Date($product->getCustomOption('aw_booking_to')->getValue()." ". $product->getCustomOption('aw_booking_time_to')->getValue(), AW_Core_Model_Abstract::DB_DATETIME_FORMAT)
		);
		
		if ($this->formatTime($data[0], 'short') != $this->formatTime($data[1], 'short')) {		
			return array(
				array('label' => $this->__('Entrance Date'), 'value' => $this->formatDate($data[0], 'medium') )
				,array('label' => $this->__('Timeslot'), 'value' => $this->formatTime($data[0], 'short') . ' ' . $this->__('time to') . ' ' . $this->formatTime($data[1], 'short'))
			);
		} else {
			return array(
				array('label' => $this->__('Entrance Date'), 'value' => $this->formatDate($data[0], 'medium') )
			);
		}
	}

    /**
     * Return merged options array
     * This array consist of standard Magento options and booking
     * @return array
     */
    public function getOptionList(){
        return array_merge($this->_getBookingOptions(), parent::getOptionList());
    }
 
}
