<?php

/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/AW-LICENSE-COMMUNITY.txt
 * 
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * aheadWorks does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * aheadWorks does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   AW
 * @package    AW_Customsmtp
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/AW-LICENSE-COMMUNITY.txt
 */class AW_Customsmtp_Model_Email_Template extends Mage_Core_Model_Email_Template {

    protected function _saveMail($email, $name=null, array $variables = array()) {
        Mage::getModel('customsmtp/mail')
        ->setSubject()
        ->setIsPlain()
        ->setBody()
        ->setFromEmail()
        ->setFromName()
        ->setToEmail()
        ->setToName()
        ->save();

        return $this;
    }

    public function sendMail(AW_Customsmtp_Model_Mail $Mail) {
        if (Mage::getStoreConfig('customsmtp/general/mode') == AW_Customsmtp_Model_Source_Mode::OFF) {
            return $this;
        }
        $config = array(
            'port' => Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_PORT), //optional - default 25
            'auth' => Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_AUTH),
            'username' => Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_LOGIN),
            'password' => Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_PASSWORD)
        );

        $needSSL = Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_SSL);
        if (!empty($needSSL)) {
            $config['ssl'] = Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_SSL);
        }

        $transport = new Zend_Mail_Transport_Smtp(Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_SMTP_HOST), $config);
        ini_set('SMTP', Mage::getStoreConfig('system/smtp/host'));
        ini_set('smtp_port', Mage::getStoreConfig('system/smtp/port'));

        $mail = $this->getMail();

        $mail->setSubject('=?utf-8?B?' . base64_encode($Mail->getSubject()) . '?=');
        $mail->addTo($Mail->getToEmail(), '=?utf-8?B?' . base64_encode($Mail->getToName()) . '?=');
        $mail->setFrom($Mail->getFromEmail(), $Mail->getFromName());

        if ($Mail->getIsPlain()) {
            $mail->setBodyText($Mail->getBody());
        } else {
            $mail->setBodyHTML($Mail->getBody());
        }

        $this->setUseAbsoluteLinks(true);

        try {
            $mail->send($transport); //add $transport object as parameter
            $this->_mail = null;
        } catch (Exception $e) {
            //print_r($e); die();
            $Mail
            ->setBody($e->getMessage())
            ->setStatus('failed')
            ->save();
            throw($e);
            return false;
        }
        return true;
    }

    public function send($email, $name=null, array $variables = array()) {

        if (!Mage::getStoreConfig(AW_Customsmtp_Helper_Config::XML_PATH_ENABLED)) {
            return parent::send($email, $name, $variables);
        }

        if (!$this->isValidForSend()) {
            return false;
        }

        $Mail = Mage::getModel('customsmtp/mail');

        if (is_null($name)) {
            $name = substr($email, 0, strpos($email, '@'));
        }

        $variables['email'] = $email;
        $variables['name'] = $name;

        $Mail->setBody($this->getProcessedTemplate($variables, true));
        $Mail->setIsPlain($this->isPlain());
        $Mail->setSubject($this->getProcessedTemplateSubject($variables));


        $Mail
        ->setFromName($this->getSenderName())
        ->setFromEmail($this->getSenderEmail())
        ->setReplyTo($this->getReplyTo())
        ->setToName($name)
        ->setToEmail($email)
        ->setTemplateId($this->getTemplateId())
        ->setStoreId(Mage::app()->getStore()->getId());



        if (Mage::getStoreConfig('customsmtp/general/log')) {
            $Mail->save();
        }

        if (Mage::getStoreConfig('customsmtp/general/mode') == AW_Customsmtp_Model_Source_Mode::ON) {
            $this->sendMail($Mail);
        } elseif (Mage::getStoreConfig('customsmtp/general/mode') == AW_Customsmtp_Model_Source_Mode::CORE) {
            try {
                return parent::send($email, $name, $variables);
            } catch (Exception $e) {
                if (Mage::getStoreConfig('customsmtp/general/log')) {
                    $Mail
                    ->setBody($e->getMessage())
                    ->setStatus('failed')
                    ->save();
                } else {
                    throw $e;
                }
            }
        }
        return true;
    }

}
