<?php
class FandM_TicketValidator_CashDeskServiceController extends Mage_Core_Controller_Front_Action
{
	
	function indexAction()
    {
    	$this->_redirect("ticketvalidator/CashDeskService/validator", 
    		$this->getRequest()->getParams());
    }
    
    function validatorAction() {
    	if (Mage::getStoreConfig('fandm/ticketvalidator/enabled')) {
    		$params = $this->getRequest()->getParams();
    		if (sizeof($params) == 0) {
    			Mage::log("TicketValidator: No Action");	
    		} elseif (sizeof($params) == 1) {
    			foreach($params as $key => $value) {
    				if ($value) {
    					Mage::log("TicketValidator: Validate Ticket ".$value." by ".$key);
    					$xml = $this->validateTicket($key, $value);
    					Mage::log($xml);
    					$request = $this->getResponse()->setBody($xml);
    				} else if ($value == "" && $this->getRequest()->getRawBody() == "") {
    					$date = substr($key, 0, 10);
    					Mage::log("TicketValidator: Lade tickets für ".$date);
    					$this->loadTickets($date);
    				} else {
    					Mage::log("TicketValidator: Update Tickets by ".$key);
    					$this->updateTickets($key);
    				}
    			}
    		} else {
    			Mage::log("TicketValidator: Corrupt Parameters");	
    		}
    	}
    }
    
    function loadTickets($date) {
    	$tickets = array();
    	$doc = new DOMDocument();
    	$r = $doc->createElementNS("http://schemas.datacontract.org/2004/07/VSSAdapter", "Tickets");
    	$doc->appendChild($r); 	
    	
    	$day_arr = explode(".", $date);
    	$read_sql = "select ticket_number from fandm_visitatebarcodes_ticket where ".
        	"entrance_ts > '".$day_arr[2]."-".$day_arr[1]."-".$day_arr[0]."'";
    	Mage::log($read_sql);
    	$res = Mage::getSingleton('core/resource')->getConnection('core_read')->query($read_sql);
		while ($row = $res->fetch()) {
			/* @var $ticket FandM_VisitateBarcodes_Model_Ticket */
			$ticket = Mage::getModel('visitatebarcodes/ticket');
    		$ticket->load($row["ticket_number"], 'ticket_number');
    		$item = $ticket->getInvoiceItem();
    		if ($item) {
    			$ticket_el = $doc->createElement("Ticket");
    			$canceled = $ticket->getData("canceled");
    			if (is_null($canceled)) {
    				$canceled = "0001-01-01T00:00:00";
    			} else {
    				$canceled = str_replace(" ", "T", $canceled)."+02:00";
    			}
    			$validated = $ticket->getData("validated");
    			$validated_by = $ticket->getData("validated_by");
    			if (is_null($validated)) {
    				$validated = "0001-01-01T00:00:00";
    				$validated_by = 0;
    			} else {
    				$validated = str_replace(' ', "T", $validated)."+02:00";
    			}
    			$entrance_ts = str_replace(' ', "T", $ticket->getData("entrance_ts"))."+02:00";
    			
	    		$this->appendChilds($ticket_el, array(
						"articleName" => $item->getName(),
						"canceled" => $canceled, 
		  				"duration" => 0,
						"ticketNumber" => $row["ticket_number"],
						"tsDate" => $entrance_ts,
						"validated" => $validated,
						"validated_by" => $validated_by
					), $doc);
				$r->appendChild($ticket_el);
    		}	
  		}
  		$xml = $doc->saveXML();
    	$request = $this->getResponse()->setBody($xml);
    }
    
    function validateTicket($casse_id, $barcode) {
    	$xml = array(
    		"ticketNumber" => $barcode,
    		"valid" => "true",
    		"status" => "OK",
    		"reason" => "Willkommen" 
    	);
    	/* @var $ticket FandM_VisitateBarcodes_Model_Ticket */
    	$ticket = Mage::getModel('visitatebarcodes/ticket');
    	$ticket->load($barcode, 'ticket_number');
    	if ($ticket->isEmpty()) {
    		// ticket not found
    		$xml["status"] = "UNKNOWN";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket ist unbekannt!";
    	} else if ($ticket->getData("canceled") && $ticket->getData("canceled_by")) {
    		$xml["status"] = "CANCELED";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket wurde gecanceled!".
       			"\n am: ".$ticket->getData("canceled").
                "\n Canceled By: ".$ticket->getData("canceled_by");
    	} else if ($ticket->getData("validated") && $ticket->getData("validated_by")){
    		// ticket allready validated
    		$xml["status"] = "DUPLICATE";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket wurde schon mal entwertet!".
            	" \n Scanner: ".$ticket->getData("validated_by");
    	} else if ($ticket->getAWFromDate()) {
    		$curr_time = time();
    		$day_arr = explode(".", $ticket->getAWFromDate());
    		$from_timestamp = $to_timestamp = 0;
    		if (!$ticket->getAWTimeFrom() || !$ticket->getAWTimeTo()) {
    			// day-ticket
    			$from_timestamp = mktime(0, 0, 0, $day_arr[1], $day_arr[0], "20".$day_arr[2]);
    			$to_timestamp = mktime(23, 59, 59, $day_arr[1], $day_arr[0], "20".$day_arr[2]);	
    		} else {
    			// timeslot ticket
    			$from_time_arr = explode(":", $ticket->getAWTimeFrom());
    			$to_time_arr = explode(":", $ticket->getAWTimeTo()); 
    			$from_timestamp = mktime($from_time_arr[0], $from_time_arr[1], 0, $day_arr[1], $day_arr[0], "20".$day_arr[2]);
    			$to_timestamp = mktime($to_time_arr[0], $to_time_arr[1], 0, $day_arr[1], $day_arr[0], "20".$day_arr[2]);
    		}
    		if ($ticket->getData("counter") <= 1) {
    			// zweite Validierung - überprüffung vom zeitfenster ist nicht nötig
    			$ticket->setData("counter", 0);
    			$ticket->setData("validated", date("Y-m-d H:i:s", $curr_time));
    			$ticket->setData("validated_by", $casse_id);
    		} else if ($curr_time < $from_timestamp) {
    			// to early
    			$xml["status"] = "EARLY";
    			$xml["valid"] = "false";
    			$xml["reason"] = "Zu früh!\nEinlass ab ".date("Y-m-d H:i:s", $from_timestamp);
    		} else if ($curr_time > $to_timestamp) {
    			// to late
    			$xml["status"] = "EXPIRED";
    			$xml["valid"] = "false";
    			
    			$xml["reason"] = "Zu spät!\nEinlass bis ".date("Y-m-d H:i:s", $to_timestamp);
    		} else {
    			$ticket->setData("counter", $ticket->getData("counter") - 1);
    		}
    		$ticket->save();
    	}
    	$xml = $this->xmlSerializer($xml, "TicketStatus");
    	return $xml;
    }
    
    function updateTickets($casse) {
    	$params = $this->getRequest()->getParams();
    	if ($this->getRequest()->getHeader("Content-Type") == "application/xml") {
    		$xml = $this->getRequest()->getRawBody(); 
    		/* $xml = '<?xml version="1.0"?><TicketIDs xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="http://schemas.datacontract.org/2004/07/VSSAdapter"><string>00000306478561014100</string><string>00000306478561014200</string><string>00000306478561014300</string></TicketIDs>'; */ 
    		/* @var $xmlObj SimpleXMLElement */
    		$xmlObj = simplexml_load_string($xml);
    		foreach ($xmlObj->children() as $id) {
    			Mage::log("Validating Ticket : ".$id);
    			$this->validateTicket($casse, $id);
    			$this->validateTicket($casse, $id);	
    		}
    		
    	}
    	
    }
    
    function xmlSerializer($array, $root, $namespace = "") {
    	$doc = new DOMDocument();
    	$r = $doc->createElementNS("http://schemas.datacontract.org/2004/07/VSSAdapter", $root);
    	$doc->appendChild($r);
    	$this->appendChilds($r, $array, $doc);
    	return $doc->saveXML();
    }
    
    function appendChilds($root, $array, $doc) {
    	foreach ($array as $key => $value) {
    		$el = $doc->createElement($key);
    		if (is_array($value)) {
    			$this->appendChilds($el, $value, $doc);	
    		} else {
    			$el->appendChild($doc->createTextNode($value));
    		}
    		$root->appendChild($el);
    	}
    }
}
