<?php
class FandM_TicketValidator_CashDeskServiceController extends Mage_Core_Controller_Front_Action
{
	
	function indexAction()
    {
    	$this->_redirect("ticketvalidator/CashDeskService/validator", 
    		$this->getRequest()->getParams());
    }
        
    function validatorAction() {
    	if (Mage::getStoreConfig('fandm/ticketvalidator/enabled')) {
    		$params = $this->getRequest()->getParams();
		Mage::log('TicketValidator: Started with Requestparams: '. print_r($params, true));
		Mage::log('TicketValidator: RawBody: |' . $this->getRequest()->getRawBody() . '|');
    		if (sizeof($params) == 0) {
    			Mage::log("TicketValidator: No Action");	
    		} elseif (sizeof($params) == 1) {
    			foreach($params as $key => $value) {
    				if ($value) {
    					Mage::log("TicketValidator: Validate Ticket ".$value." by ".$key);
    					$xml = $this->validateTicket($key, $value);
    					Mage::log($xml);
    					$request = $this->getResponse()->setBody($xml);
    					$request = $this->getResponse()->setHeader("content-type", "application/xml");
    				} else if ($value == "" && $this->getRequest()->getRawBody() == "") {
    					$date = substr($key, 0, 10);
    					Mage::log("TicketValidator: Lade tickets fr ".$date);
    					$this->loadTickets($date);
    				} else {
    					Mage::log("TicketValidator: Update Tickets by ".$key);
    					$this->updateTickets($key);
    				}
    			}
    		} else {
    			Mage::log("TicketValidator: Corrupt Parameters");	
    		}
    	}
    }
    
    function loadTickets($date) {
    	$tickets = array();
    	$doc = new DOMDocument();
    	$r = $doc->createElementNS("http://schemas.datacontract.org/2004/07/VSSAdapter", "Tickets");
    	$doc->appendChild($r); 	
    	
    	$day_arr = explode(".", $date);
    	$read_sql = "select ticket_number from fandm_barcodetickets_ticket where ".
        	"DATE_FORMAT(entrance_ts,'%Y-%m-%d') = '".$day_arr[2]."-".$day_arr[1]."-".$day_arr[0]."'";
    	$res = Mage::getSingleton('core/resource')->getConnection('core_read')->query($read_sql);
		while ($row = $res->fetch()) {
			/* @var $ticket FandM_BarcodeTickets_Model_Ticket */
			$ticket = Mage::getModel('barcodetickets/ticket');
    		$ticket->load($row["ticket_number"], 'ticket_number');
    		$item = $ticket->getInvoiceItem();
    		if ($item) {
    			$ticket_el = $doc->createElement("Ticket");
    			$canceled = $ticket->getData("canceled");
    			if (is_null($canceled)) {
    				$canceled = "0001-01-01T00:00:00";
    			} else {
    				$canceled = str_replace(" ", "T", $canceled);
    			}
    			$validated = $ticket->getData("validated");
    			$validated_by = $ticket->getData("validated_by");
    			if (is_null($validated)) {
    				$validated = "0001-01-01T00:00:00";
    				$validated_by = 0;
    			} else {
    				$validated = str_replace(' ', "T", $validated);
    			}
    			$entrance_ts = str_replace(' ', "T", $ticket->getData("entrance_ts"));
    			
	    		$this->appendChilds($ticket_el, array(
						"articleName" => $item->getName(),
						"canceled" => $canceled, 
		  				"duration" => $ticket->isTimeslotTicket()? 30 : 1440,
						"ticketNumber" => $row["ticket_number"],
						"tsDate" => $entrance_ts,
						"validated" => $validated,
						"validated_by" => $validated_by
					), $doc);
				$r->appendChild($ticket_el);
    		}	
  		}
  		$xml = $doc->saveXML();
    	$request = $this->getResponse()->setBody($xml);
    	$request = $this->getResponse()->setHeader("content-type", "application/xml");
    }
    
    function validateTicket($casse_id, $barcode, $online = true) {
    	$xml = array(
    		"ticketNumber" => $barcode,
    		"valid" => "true",
    		"status" => "OK",
    		"reason" => "Willkommen" 
    	);
    	/* @var $ticket FandM_BarcodeTickets_Model_Ticket */
    	$ticket = Mage::getModel('barcodetickets/ticket');
    	$ticket->load($barcode, 'ticket_number');
    	/* @var $curr_time Zend_Date */
    	$curr_time = new Zend_Date();
    	$curr_time->setTimezone('Europe/Berlin');
    	$config_counter = Mage::getStoreConfig('fandm/ticketvalidator/validation_counter');

    	if ($ticket->isEmpty()) {
    		// ticket not found
    		$xml["status"] = "UNKNOWN";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket ist unbekannt!";
    	} else if ($ticket->getData("canceled") && $ticket->getData("canceled_by") != null) {
    		$xml["status"] = "CANCELED";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket wurde gecanceled!".
       			"\n am: ".$ticket->getData("canceled").
                "\n Canceled By: ".$ticket->getData("canceled_by");
    	} else if ($ticket->getData("validated") && $ticket->getData("validated_by") != null){
    		// ticket allready validated
    		$xml["status"] = "DUPLICATE";
    		$xml["valid"] = "false";
    		$xml["reason"] = "Das Ticket wurde schon mal entwertet!".
            	" \n Scanner: ".$ticket->getData("validated_by");
    	} else {
    		if ($ticket->getData("counter") <= 1 && $config_counter > 1) {
	    		// zweite Validierung - überprüffung vom zeitfenster ist nicht nötig
	    		$ticket->setData("counter", 0);
	    		$ticket->setData("validated", $curr_time->toString("Y-MM-dd HH:mm:ss"));
	    		$ticket->setData("validated_by", $casse_id);
	    	} else if ($online && $curr_time->isEarlier($ticket->getTimestampFrom())) {
	    		// to early
	    		$xml["status"] = "EARLY";
	    		$xml["valid"] = "false";
	    		$xml["reason"] = "Zu früh!\nEinlass ab ".$ticket->getTimestampFrom()->toString("dd.MM.YYYY H:mm", null, 'de_DE');
	    	} else if ($online && $curr_time->isLater($ticket->getTimestampTo())) {
	    		// to late
	    		$xml["status"] = "EXPIRED";
	    		$xml["valid"] = "false";
	    		$xml["reason"] = "Zu spät!\nEinlass bis ".$ticket->getTimestampTo()->toString("dd.MM.YYYY H:mm", null, 'de_DE');
	    	} else {
	    		$ticket->setData("counter", $ticket->getData("counter") - 1);
	    		if ($ticket->getData("counter") < 1) {
	    			$ticket->setData("validated", $curr_time->toString("Y-MM-dd HH:mm:ss"));
	    			$ticket->setData("validated_by", $casse_id);
	    		}
	    	}
	    	$ticket->save();
    	}
    	$xml = $this->xmlSerializer($xml, "TicketStatus");
    	return $xml;
    }
    
    function updateTickets($casse) {
    	Mage::log("start");
    	//if ($this->getRequest()->getHeader("Content-Type") == "application/xml") {
    		Mage::log("application/xml");
    		$xml = $this->getRequest()->getRawBody(); 
    		/* $xml = '<?xml version="1.0"?><TicketIDs xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="http://schemas.datacontract.org/2004/07/VSSAdapter"><string>00000306478561014100</string><string>00000306478561014200</string><string>00000306478561014300</string></TicketIDs>'; */ 
    		/* @var $xmlObj SimpleXMLElement */
    		$xmlObj = simplexml_load_string($xml);
    		foreach ($xmlObj->children() as $id) {
    			Mage::log("Validating Ticket : ".$id);
    			$this->validateTicket($casse, $id, false);
    		}
    		
    	//}
    	
    }
    
    function xmlSerializer($array, $root, $namespace = "") {
    	$doc = new DOMDocument();
    	$r = $doc->createElementNS("http://schemas.datacontract.org/2004/07/VSSAdapter", $root);
    	$doc->appendChild($r);
    	$this->appendChilds($r, $array, $doc);
    	return $doc->saveXML();
    }
    
    function appendChilds($root, $array, $doc) {
    	foreach ($array as $key => $value) {
    		$el = $doc->createElement($key);
    		if (is_array($value)) {
    			$this->appendChilds($el, $value, $doc);	
    		} else {
    			$el->appendChild($doc->createTextNode($value));
    		}
    		$root->appendChild($el);
    	}
    }
}
