<?php

class FandM_BarcodeTickets_Model_Observer extends Mage_Core_Controller_Front_Action
{
	public function __construct()
	{
		if (!defined("DOMPDF_FONT_CACHE")) {
            $domPdfFontCacheDir = Mage::helper('dompdf')->getFontCacheDir();
            define("DOMPDF_FONT_CACHE", $domPdfFontCacheDir);
            
        }
        require_once 'Symmetrics/dompdf/dompdf_config.inc.php';
        spl_autoload_unregister(array(Varien_Autoload::instance(), 'autoload'));
        spl_autoload_register('DOMPDF_autoload');
        Varien_Autoload::register();
	}
	
	/**
	 *
	 *@param Mage_Sales_Model_Order_Invoice $invoice
	 */
	public function getTicketsPDF($invoice) {
		$this->createTicket($invoice);
		/* @var $template Mage_Core_Model_Email_Template */
		$template = Mage::getModel('core/email_template');
		$template = $template->load(Mage::getStoreConfig('fandm/barcodetickets/dayticket_template'));
		$date_tpl_text = $template->getPreparedTemplateText();
		$template = $template->load(Mage::getStoreConfig('fandm/barcodetickets/daytimeticket_template'));
		$datetime_tpl_text = $template->getPreparedTemplateText();
		
		$bp = new FandM_BarcodeTickets_Model_BarcodePrinter();
		$dompdf = new DOMPDF();
		$draw_html_text = "";
        
        foreach ($invoice->getAllItems() as $item) {
        	/* @var $item Mage_Catalog_Model_Product */
			if ($item->getOrderItem()->getParentItem()) {
            	continue;
            }
            if ($item->getSku() != Mage::getStoreConfig( "fandm/mandatoryitems/default_sku")
            	&& $item->getSku() != Mage::getStoreConfig("fandm/mandatoryitems/sku1")) {
            	// @var $orderItem Mage_Sales_Model_Order_Item
            	for ($i = 0; $i < $item->getQty(); $i++) {
            		$tpl_text = "";
            		// try get ticket
                   	$read_sql = "select id, ticket_number from fandm_barcodetickets_ticket where ".
        				"invoice_id = ".$invoice->getId()." AND ".
            			"invoice_item_id = ".$item->getId()." AND ".
    					"invoice_item_counter = ".$i;
                   	$ticket_num = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchRow($read_sql);
                   	$Barcode = $bp->barcode_print($ticket_num["ticket_number"], "128B", 1.5, "html");
    				$BarcodeNum = $ticket_num["ticket_number"];
            		
    				/* @var $ticket FandM_VisitateBarcodes_Model_Ticket */
        			$ticket = Mage::getModel('barcodetickets/ticket');
        			$ticket->setInvoiceItem($item);
    				$from = $ticket->getTimestampFrom();
					// add time
					if ($from) {
            			$var = $item->getOrderItem()->getProductOptions();
				        $from_date = explode(".", $var["info_buyRequest"]["aw_booking_from"]);
				        $from_date = $from_date[2]."-".$from_date[1]."-".$from_date[0];
				        $timestamp = strtotime($from_date);
				        $Date = strftime("%A, %d.%m.20%y", $timestamp);				        
					}
					$Hours = "";
	            	if (isset($var["info_buyRequest"]["aw_booking_time_from"]["hours"])) {
			        	$Hours = $var["info_buyRequest"]["aw_booking_time_from"]["hours"].":".$var["info_buyRequest"]["aw_booking_time_from"]["minutes"]. 
			            	" - ".$var["info_buyRequest"]["aw_booking_time_to"]["hours"].":".$var["info_buyRequest"]["aw_booking_time_to"]["minutes"];
			        	$tpl_text = $datetime_tpl_text;
			        } else {
				        $Hours = Mage::helper('sales')->__("Within the opening hours of the booked date");
				        $tpl_text = $date_tpl_text;
				    }
				    $Product = $item->getName();
				    $Price = sprintf("%.2f", $item->getPriceInclTax());
				    // fill data
  	    			$html = str_replace("{{Barcode}}", $Barcode, $tpl_text);
  	    			$html = str_replace("{{BarcodeNum}}", $BarcodeNum, $html);
  	    			$html = str_replace("{{Date}}", $Date, $html);
  	    			$html = str_replace("{{Hours}}", $Hours, $html);
  	    			$html = str_replace("{{Product}}", $Product, $html);
  	    			$html = str_replace("{{Price}}", $Price, $html);
            		$draw_html_text .= $html;
                }
            }
        }   
        if ($draw_html_text != "") {
        	// leeres <style> tag muss drin bleiben, sonst koennen keine bilder hinzugefuegt werden!
        	$html = "<html><head><style></style></head><body>".$draw_html_text."</body></html>";
        	$dompdf->load_html($html);
        	$image_path = Mage::getStoreConfig('system/filesystem/skin')."/";
        	$dompdf->set_base_path($image_path);
	        $dompdf->render();
	        return $dompdf->output();
        } else {return null;}
	}
	
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function addBarcodeTicketsPDF($observer) {
		if (Mage::getStoreConfig('fandm/barcodetickets/enabled')) {
			$mailTemplate = $observer->getData("mail_template");
			$invoice = $observer->getData("invoice");
			/* @var $mailTemplate AW_Customsmtp_Model_Email_Template */
			$pdf = $this->getTicketsPDF($invoice);
			if ($pdf != null)
				$mailTemplate = $this->addAttachment($this->getTicketsPDF($invoice), $mailTemplate);
		}
		return $observer;
	}
	
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function send_mail($observer) {
		$event = $observer->getEvent();
	    $invoice = $event->getInvoice();
		$invoice->sendEmail(true, '');
	    $invoice->setEmailSent(true);
	    return $observer;
	}
	
    public function addAttachment($pdf, $mailObj, $name = "tickets") {
        try{
            $mailObj->getMail()->createAttachment($pdf,'application/pdf',Zend_Mime::DISPOSITION_ATTACHMENT,Zend_Mime::ENCODING_BASE64,$name.'.pdf');
        } catch (Exception $e){
            Mage::log(Mage::helper('emailattachments')->__('Caught error while attaching pdf: %s'),$e->getMessage());
        }
        return $mailObj;
    }
    
    protected function numToBarcode($num)
    {
        $str = $num;
        $barcode_data = str_replace(' ', chr(128), $str);

        $checksum = 104; # must include START B code 128 value (104) in checksum
        for($i=0;$i<strlen($str);$i++) {
            $code128 = '';
            if (ord($barcode_data{$i}) == 128) {
            	$code128 = 0;
            } elseif (ord($barcode_data{$i}) >= 33 && ord($barcode_data{$i}) <= 126) {
            	$code128 = ord($barcode_data{$i}) - 32;
            } elseif (ord($barcode_data{$i}) >= 145) {
            	$code128 = ord($barcode_data{$i}) - 50;
            }
	        $checksum_position = $code128 * ($i + 1);
	        $checksum += $checksum_position;
        }
        $check_digit_value = $checksum % 103;
        $check_digit_ascii = '';
        if ($check_digit_value == 0) {
            $check_digit_ascii = 128;
        } elseif ($check_digit_value <= 94) {
            $check_digit_ascii = $check_digit_value + 32;
        } elseif ($check_digit_value > 94) {
            $check_digit_ascii = $check_digit_value + 50;
        }
        $barcode_str = chr(154) . $barcode_data . chr($check_digit_ascii) . chr(156);
            
        return $barcode_str;
    }
    
    /**
     * 
     * @param Mage_Sales_Model_Order_Invoice $invoice
     */
    public function createTicket($invoice) {
    	$read_sql = "select count(*) as count from fandm_barcodetickets_ticket where ".
        				"invoice_id = ".$invoice->getId();
        $row = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchRow($read_sql);
    	if ($row["count"] != 0) return;	
    	foreach($invoice->getAllItems() as $item) {
   			/* @var $item Mage_Sales_Model_Order_Invoice_Item */
   			if ($item->getSku() != Mage::getStoreConfig( "fandm/mandatoryitems/default_sku")
               	&& $item->getSku() != Mage::getStoreConfig("fandm/mandatoryitems/sku1")) {
               	$customer_id = Mage::getStoreConfig('fandm/barcodetickets/customer_id');
               	for ($i = 0; $i < $item->getQty(); $i++) {
               		$article_id = str_replace("-", "", $item->getSku());
               		/* @var $ticket FandM_BarcodeTickets_Model_Ticket */
   					$ticket = Mage::getModel('barcodetickets/ticket');
   					$ticket->setData("invoice_id", $invoice->getId());
			    	$ticket->setData("invoice_item_id", $item->getId());
			    	$ticket->setData("invoice_item_counter", $i);
			    	$ticket->setData("customer_id", $invoice->getOrder()->getData("customer_id", 0));
			    	$ticket->setData("article_id", $article_id);
					$ticket->setData("price", $item->getPriceInclTax());
					$ticket->setData("counter", Mage::getStoreConfig('fandm/ticketvalidator/validation_counter'));
					if ($ticket->getTimestampFrom())
						$ticket->setData("entrance_ts", $ticket->getTimestampFrom()->toString('Y-MM-dd HH:mm:ss'));
					
					// check if f�hrung
					$product = $ticket->getProduct();
					if ($product && !$product->getData("fm_is_entrance_ticket")) {
						$ticket->setData("counter", 0);
   						$ticket->setData("validated", date("Y-m-d H:i:s", time()));
   						$ticket->setData("validated_by", "SYSTEM");
					}
						
			       	$ticket->save();
			    	
       				$ticket->setData("ticket_number", 
			    		"000".
			    		$this->zero_fill($customer_id, 3).
			    		$this->zero_fill($article_id, 7).
			    		$this->zero_fill($ticket->getData("id", 0), 7));
			    	$ticket->save();
               	}
         	}
	    }		
    }
    
    public function zero_fill($str, $len) {
    	for($i = strlen($str); $i < $len; $i++) {
    		$str = "0".$str;
    	}
    	return $str;
    }
    
}

